/** <!------------------------------------------------------------------------->
*
*  @file SchM_IpduM.c
*
*  @brief
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2014, dSPACE GmbH. All rights reserved.
*
*<!-------------------------------------------------------------------------->*/

#ifndef SCHM_IPDUM_C
#define SCHM_IPDUM_C

/*----------------------------------------------------------------------------*\
  DEFINES (OPT)
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  INCLUDES
\*----------------------------------------------------------------------------*/

#include "SchM_IpduM.h"
/*----------------------------------------------------------------------------*\
  DEFINES
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  TYPEDEFS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  ENUMS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  VARIABLES
\*----------------------------------------------------------------------------*/
UNUSED static uint32 InterruptStatus = 0;

/*----------------------------------------------------------------------------*\
  PARAMETERIZED MACROS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  FUNCTION DEFINITIONS
\*----------------------------------------------------------------------------*/

/*************************************************************************************************\
 ***  FUNCTION:
 ***      SchM_Enter_IpduM
 ***
 ***  DESCRIPTION:
 ***      Enter a module local exclusive area.
 ***
 ***  PARAMETERS:
 ***      Type               Name                Description
 ***      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***      uint8              Instance
 ***      uint8              ExclusiveArea
 ***
 ***  RETURNS:
 ***      void
 ***
 ***  SETTINGS:
 ***
\*************************************************************************************************/
void SchM_Enter_IpduM(uint8 Instance, uint8 ExclusiveArea)
{
    switch (Instance) {
        case IPDUM_INSTANCE: {
            switch (ExclusiveArea) {
                case SCHM_IPDUM_EXCLUSIVE_AREA: {
                    DS_RTOS_INT_SAVE_AND_DISABLE(InterruptStatus);
                    break;
                }
            }
            break;
        }
    }
}

/*************************************************************************************************\
 ***  FUNCTION:
 ***      SchM_Exit_IpduM
 ***
 ***  DESCRIPTION:
 ***      Exit a module local exclusive area.
 ***
 ***  PARAMETERS:
 ***      Type               Name                Description
 ***      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***      uint8              Instance
 ***      uint8              ExclusiveArea
 ***
 ***  RETURNS:
 ***      void
 ***
 ***  SETTINGS:
 ***
\*************************************************************************************************/
void SchM_Exit_IpduM(uint8 Instance, uint8 ExclusiveArea)
{
    switch (Instance) {
        case IPDUM_INSTANCE: {
            switch (ExclusiveArea) {
                case SCHM_IPDUM_EXCLUSIVE_AREA: {
                    DS_RTOS_INT_RESTORE(InterruptStatus);
                    break;
                }
            }
            break;
        }
    }
}

/*----------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*----------------------------------------------------------------------------*/


#endif/*SCHM_IPDUM_C */
/*----------------------------------------------------------------------------*\
 END OF FILE
\*----------------------------------------------------------------------------*/
